<?php

/**
 * @copyright   Copyright (C) 2015 Ryan Demmer. All rights reserved
 * @copyright   Copyright (C) 2005 - 2014 Open Source Matters, Inc. All rights reserved
 * @license     GNU General Public License version 2 or later
 */
defined('JPATH_BASE') or die;

/**
 * JCE.
 *
 * @since       2.5.5
 */
class PlgSystemJMediaPro extends JPlugin
{
    public function __construct(&$subject, $config = [])
    {
        parent::__construct($subject, $config);

        // update license key
        $cache = JFactory::getCache('jmedia');
        $cache->get(['PlgSystemJMediaPro', 'updateLicenseKeys']);
    }

    public function onJMediaLicenseValidation($context)
    {
        if ($context == 'com_jmedia.license' && ! defined('JMDEDIA_LICENSE')) {
            define('JMDEDIA_LICENSE', 'PRO');

            return true;
        }
    }

    public function onJMediaDisplay($context)
    {
        if ($context == 'com_jmedia.images' || $context == 'com_jmedia.media') {
            JFactory::getDocument()->addScriptDeclaration('window.pro_allowed = true;');
        }
    }

    public function onJMediaDisplayScript($context)
    {
        $input  = JFactory::getApplication()->input;
        $source = $input->get('source', '', 'string');

        if ($context == 'com_jmedia.images' || $context == 'com_jmedia.media') {
            if ($source == 'quix') {
                return;
            }

            /*
             * testing codes
             * @todo: remove it
             */
            // JFactory::getDocument()->addScriptDeclaration("Filemanager.Pluggable.registerPlugin('tx-icons', Filemanager.IconsFont);");
            // $url = JUri::root(true).'/?quix-asset=/css/qxi.css&ver=4.0.0-beta1';
            // JFactory::getDocument()->addStylesheet($url, ['media' => 'all']);

            JFactory::getDocument()->addScriptDeclaration("var Unsplash = Filemanager.Pluggable.registerPlugin('tx-unsplash', Filemanager.Unsplash);");
            JFactory::getDocument()->addScriptDeclaration("Unsplash.accessor().setClientID('QWbovST3tlmma5EdQ9uH-1NXP6gYiGSRsEdPjhqT36I');");
        }
    }

    public function onJMediaPrepareFooter($context)
    {
        return '<div class="jmedia-footer">
                <span><a href="https://www.themexpert.com/jmedia" style="color: #7f8fa4;" target="_blank"><i class="icon-question"></i>Need Help</a></span>
			    <span style="float:right;">Designed and Developed by <a href="https://www.themexpert.com">ThemeXpert</a></span>
            </div>';
    }

    /**
     * @return bool
     * @since 1.0.0
     */
    public static function updateLicenseKeys(): bool
    {
        $db    = JFactory::getDbo();
        $query = $db->getQuery(true)
                    ->select('*')
                    ->from('#__update_sites')
                    ->where($db->quoteName('name').' = '.$db->quote('JMedia Update Site'));

        $db->setQuery($query);
        $result = $db->loadObject();

        if ($result->extra_query) {
            $fields = [
                $db->quoteName('extra_query').'='.$db->quote($result->extra_query),
                $db->quoteName('last_check_timestamp').'=0'
            ];

            $query = $db->getQuery(true)
                        ->update($db->quoteName('#__update_sites'))
                        ->set($fields)
                        ->where($db->quoteName('name').'='.$db->quote('JMedia Pro Update Site'));
            $db->setQuery($query);
            $db->execute();
        }

        return true;
    }
}
