/**
 * @package     FILEman
 * @copyright   Copyright (C) 2011 Timble CVBA. (http://www.timble.net)
 * @license     GNU GPLv3 <http://www.gnu.org/licenses/gpl.html>
 * @link        http://www.joomlatools.com
 */

var FILEman = FILEman || {};

kQuery(function($) {

    FILEman.BatchForm = Koowa.Class.extend({

        save_button: null,
        cancel_button: null,

        uploader: null,

        upload_in_progress: false,

        has_unsaved_files: false,

        // used to decide whether to reload the page or not
        documents_created: false,

        options: {
            onBeforeInitialize: function(instance) {},
            onAfterInitialize: function() {},

            show_uploader: true,

            refresh_parent_on_close: true,

            save_selector: '.k-js-save',
            cancel_selector: '.k-js-cancel',
            uploader_selector: '.fileman-uploader',
            upload_warning_selector: '.k-js-upload-warning',
            close_modal_selector: '.k-js-close-modal'
        },

        initialize: function(options) {
            this.supr();

            this.setOptions(options);

            if (this.options.onBeforeInitialize) {
                this.options.onBeforeInitialize.call(this, this);
            }

            this.save_button = $(this.options.save_selector);
            this.cancel_button = $(this.options.cancel_selector);

            this.uploader = $(this.options.uploader_selector);

            if (!this.options.show_uploader) {
                this.hideUploader();
            }

            this.attachEvents();

            if (this.options.onAfterInitialize) {
                this.options.onAfterInitialize(this);
            }

            this.save_button.prop('disabled', true);
        },
        callUploader: function() {
            if (this.uploader.uploader('instance')) {
                return this.uploader.uploader(arguments);
            }

            return false;
        },
        hideUploader: function() {
            this.uploader.parent().remove();
        },
        showSuccessMessage: function() {
            $('.k-js-success-message').show();

            if (this.isOpenInModal()) {
                $('.k-js-close-modal-container').show();
            }
        },
        hideSuccessMessage: function() {
            $('.k-js-success-message').hide();
        },
        attachEvents: function() {
            var self = this;

            $(this.options.close_modal_selector).click(function(e) {
                e.preventDefault();

                self.hide();
            });

            this.uploader.on('uploader:selected', function(event, data) {
                var uploader = data.uploader;

                self.has_unsaved_files = (uploader.files.length - (uploader.total.uploaded + uploader.total.failed));

                self.hideSuccessMessage();

                self.uploader.addClass('has-open-info');
            });

            this.uploader.on('uploader:uploaded', function(event, data) {
                var file = data.file,
                    uploader = data.uploader;

                self.has_unsaved_files = (uploader.files.length - (uploader.total.uploaded + uploader.total.failed));

                if (!self.has_unsaved_files) {
                    self.showSuccessMessage();
                }

                if (file.status === plupload.DONE && typeof data.result.response !== 'undefined') {
                    self.documents_created = true;
                }
            });

            this.uploader.on('uploader:started', function() {
                self.upload_in_progress = true;
            });

            this.uploader.on('uploader:stopped', function() {
                self.upload_in_progress = false;
            });

            self.cancel_button.click(function(event) {
                event.preventDefault();

                if ((!self.has_unsaved_files && !self.upload_in_progress) || confirm(Koowa.translate('You will lose all unsaved data. Are you sure?'))) {
                    self.hide();
                }
            });

            if (self.options.refresh_parent_on_close && self.isOpenInModal()) {
                var instance = window.parent.kQuery.magnificPopup.instance;

                if (instance.ev) {
                    instance.ev.on('mfpClose', function() {
                        if (self.documents_created) {
                            window.parent.location.reload();
                        }
                    });
                }
            }
        },
        isOpenInModal: function() {
            return (window !== window.parent && window.parent.kQuery && window.parent.kQuery.magnificPopup && window.parent.kQuery.magnificPopup.instance);
        },
        hide: function() {
            if (window.parent.kQuery && window.parent.kQuery.magnificPopup && window.parent.kQuery.magnificPopup.instance) {
                window.parent.kQuery.magnificPopup.close();
            }
        }
    });
});
