<?php
/**
 * Copyright (c) 2006-2022 LogicalDOC
 * WebSites: www.logicaldoc.com
 * 
 * No bytes were intentionally harmed during the development of this application.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */
defined('_JEXEC') or die;
?>
<script language="javascript" type="text/javascript">
    $(document).ready(function() {

        $("#searchAdvanced").button().click(function() {
            var content = $('#contentText').val();
            if (content !== '') {
                document.formSearchAdvanced.task.value = 'searchAdvanced';
                document.formSearchAdvanced.submit();
            }
            else {
                $('#contentText').validationEngine('showPrompt', '<?php echo JText::_('COM_LOGICALDOC_SOME_OF_THESE_FIELDS_ARE_REQUIRED'); ?>', 'error', true);
                return false;
            }
        });

        $('*').keypress(function(e) {
            //funciona cuando se preciona la tecla enter
            if (e.keyCode == 13) {
                var content = $('#contentText').val();
                if (content !== '') {
                    document.formSearchAdvanced.task.value = 'searchAdvanced';
                    document.formSearchAdvanced.submit();
                }
                else {
                    $('#contentText').validationEngine('showPrompt', '<?php echo JText::_('COM_LOGICALDOC_SOME_OF_THESE_FIELDS_ARE_REQUIRED'); ?>', 'error', true);
                    return false;
                }
            }
        });

        $("#searchReturn").button().click(function() {
            document.formSearchAdvanced.task.value = 'returnDesktop';
            document.formSearchAdvanced.submit();
        });

        $('#formSearchAdvanced').validationEngine();

        $("#documentType").selectmenu();
    });


</script>
<form action= "" method="post" name="formSearchAdvanced" id="formSearchAdvanced" >
    <div class="panel panel-default">
        <div class="panel-heading">
            <h4><?php echo JText::_('COM_LOGICALDOC_ADVANCED_SEARCH') ?></h4>                
        </div>
        <div class="panel-body">
            <table width="100%" class="display" cellpadding="2" cellspacing="2" border="0">
                <tr>
                    <td><label for="content" class="label-title"><?php echo JText::_('COM_LOGICALDOC_CONTENT') ?>:</label></td>
                    <td>
                        <input type="text" name="content" id="contentText" value="<?php echo $this->sessionSearch->get('content'); ?>" placeholder="<?php echo JText::_('COM_LOGICALDOC_CONTENT') ?>" class="validate[required] text-input"/>
                    </td>
                </tr>															
                <tr>
                    <td><label for="type" class="label-title">Search Fields:</label></td>
                    <td>
						<div style="display: inline-block;">
							<input type="checkbox" name="sfields[]" id="sfieldsc" value="content" <?php if(in_array('content', $this->sessionSearch->get('sfields'))) echo 'checked="checked"'; ?> />
							<label>Content</label>
						</div>							
						<div style="display: inline-block;">						
							<input type="checkbox" name="sfields[]" id="sfieldst" value="title" <?php if(in_array('title', $this->sessionSearch->get('sfields'))) echo 'checked="checked"'; ?> />
							<label>Name</label>
						</div>														
						<div style="display: inline-block;">						
							<input type="checkbox" name="sfields[]" id="sfieldsk" value="tags" <?php if(in_array('tags', $this->sessionSearch->get('sfields'))) echo 'checked="checked"'; ?> />                       
							<label>Tags</label>
						</div>														
                    </td>
                </tr>				
                <tr>
                    <td><label for="" class="label-title"><?php echo JText::_('COM_LOGICALDOC_DOCUMENT_TYPE') ?>:</label></td>
                    <td>                           
                        <select id="documentType" name="documentType">
                            <option value=""></option>
                            <option value="pdf,doc,docx,odt,rtf" <?php if ($this->sessionSearch->get('documentType') == 'pdf,doc,docx,odt,rtf') echo "selected='selected'"; ?>>Document</option>
                            <option value="xls,xlsx,ods" <?php if ($this->sessionSearch->get('documentType') == 'xls,xlsx,ods') echo "selected='selected'"; ?>>Spreadsheet</option>
                            <option value="ppt,pptx,odp" <?php if ($this->sessionSearch->get('documentType') == 'ppt,pptx,odp') echo "selected='selected'"; ?>>Presentation</option>
                            <option value="txt,html,htm,xml" <?php if ($this->sessionSearch->get('documentType') == 'txt,html,htm,xml') echo "selected='selected'"; ?>>Text</option>
                            <option value="jpg,png,gif,tif,psd,dwg,bmp,tiff" <?php if ($this->sessionSearch->get('documentType') == 'jpg,png,gif,tif,psd,dwg,bmp,tiff') echo "selected='selected'"; ?>>Image</option>
                            <option value="mp3,wav" <?php if ($this->sessionSearch->get('documentType') == 'mp3,wav') echo "selected='selected'"; ?>>Audio</option>
                            <option value="avi,mkv,mp4,wmv" <?php if ($this->sessionSearch->get('documentType') == 'avi,mkv,mp4,wmv') echo "selected='selected'"; ?>>Video</option>
                            <option value="eml,msg" <?php if ($this->sessionSearch->get('documentType') == 'eml,msg') echo "selected='selected'"; ?>>Email</option>
                        </select>						
                    </td>
                </tr>
                <tr>
                    <td><label for="maxHits" class="label-title">Max Hits:</label></td>
                    <td>
                        <input type="text" name="maxHits" id="maxHits" value="<?php echo $this->sessionSearch->get('maxHits'); ?>" placeholder="40"/>
                    </td>
                </tr>				
            </table>
        </div>
        <div class="panel-footer">
            <div class="panel-button">
                <button id="searchReturn">
                    <i class="fa fa-reply"></i>
                    <?php echo JText::_('COM_LOGICALDOC_GO_BACK') ?>
                </button>
                <button id="searchAdvanced">
                    <i class="fa fa-search"></i>
                    <?php echo Jtext::_('COM_LOGICALDOC_SEARCH') ?>
                </button>  
            </div>
        </div>    
        <input type="hidden" name="option" value="com_logicaldoc" />
        <input type="hidden" name="view" value="search"/>
        <input type="hidden" name="task" value="" />
        <input type="hidden" name="id" value="<?php echo $this->rowConfiguration->idConfiguration; ?>"/>
    </div><!--fin del tabs-->
</form>