<?php
/**
 * @license    License compatible with GNU General Public License (GNU GPL); see file LICENSE
 */


namespace logicaldoc;

defined('_JEXEC') or die('Restricted access');


//require_once(__DIR__ . '/vendor/autoload.php');

/**
 * LogicalDOC
 *
 */
class LogicalDOC {

    const DIR_GLUE = DIRECTORY_SEPARATOR;
    const NS_GLUE = '\\';

    public function __construct() {
        spl_autoload_register(array($this, 'autoload'));
    }

    public function autoload($classname) {
        $base = dirname(dirname(__FILE__));
        $parts = explode(self::NS_GLUE, $classname);
        $path = $base . self::DIR_GLUE . implode(self::DIR_GLUE, $parts) . '.php';

        if (file_exists($path)) {
            require_once($path);
        }
    }	

}

?>
