<?php
/**
 * @license    License compatible with GNU General Public License (GNU GPL); see file LICENSE
 */

/**
 * EnterpriseSearchApi
 * PHP version 5
 *
 * @category Class
 * @package  Swagger\Client
 * @author   Swagger Codegen team
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * LogicalDOC REST API
 *
 * This is the interactive documentation of the REST APIs exposed by LogicalDOC. You can find more information about LogicalDOC at <a href=\"https://www.logicaldoc.com\">https://www.logicaldoc.com</a> or on Twitter @logicaldoc.<br/>                Note: The access path to the API is protected with basic authentication, to be able to run the samples you must log in using the credentials of a Logicaldoc user, or passing to the request the session ID (SID) as a cookie (cookie name: `ldoc-sid`).<br/><br/>             Here is an example to list the children folders: <br/> <pre>curl -u admin:admin -H 'Accept: application/json' http://localhost:8080/services/rest/folder/listChildren?folderId=4</pre><br/><br/>RESTful Guide with curl:  <a href='https://wiki.logicaldoc.com/wiki/RESTful_Guide_with_curl'>https://wiki.logicaldoc.com/wiki/RESTful_Guide_with_curl</a> <br/><br/>Practical examples of use are available for various programming languages at: <a href='http://wiki.logicaldoc.com/wiki/Bindings_And_Samples'>http://wiki.logicaldoc.com/wiki/Bindings_And_Samples</a>
 *
 * OpenAPI spec version: 8.6.0-oas3
 * Contact: devel@logicaldoc.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 * Swagger Codegen version: 3.0.33
 */
/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace Swagger\Client\Api;

defined('_JEXEC') or die('Restricted access');


use GuzzleHttp\Client;
use GuzzleHttp\ClientInterface;
use GuzzleHttp\Exception\RequestException;
use GuzzleHttp\Psr7\MultipartStream;
use GuzzleHttp\Psr7\Request;
use GuzzleHttp\RequestOptions;
use Swagger\Client\ApiException;
use Swagger\Client\Configuration;
use Swagger\Client\HeaderSelector;
use Swagger\Client\ObjectSerializer;

/**
 * EnterpriseSearchApi Class Doc Comment
 *
 * @category Class
 * @package  Swagger\Client
 * @author   Swagger Codegen team
 * @link     https://github.com/swagger-api/swagger-codegen
 */
class EnterpriseSearchApi
{
    /**
     * @var ClientInterface
     */
    protected $client;

    /**
     * @var Configuration
     */
    protected $config;

    /**
     * @var HeaderSelector
     */
    protected $headerSelector;

    /**
     * @param ClientInterface $client
     * @param Configuration   $config
     * @param HeaderSelector  $selector
     */
    public function __construct(
        ClientInterface $client = null,
        Configuration $config = null,
        HeaderSelector $selector = null
    ) {
        $this->client = $client ?: new Client();
        $this->config = $config ?: new Configuration();
        $this->headerSelector = $selector ?: new HeaderSelector();
    }

    /**
     * @return Configuration
     */
    public function getConfig()
    {
        return $this->config;
    }

    /**
     * Operation findByParameters
     *
     * Retrieve all documents that match the list of criteria
     *
     * @param  \Swagger\Client\Model\WSCriterion[] $body an array of search criteria that must be met (optional)
     * @param  int $template_id the type of documents to be retrieved (optional)
     * @param  string $order optional order expression (eg. creation desc) (optional)
     * @param  int $max_results maximum number of results (optional)
     *
     * @throws \Swagger\Client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \Swagger\Client\Model\WSDocument[]
     */
    public function findByParameters($body = null, $template_id = null, $order = null, $max_results = null)
    {
        list($response) = $this->findByParametersWithHttpInfo($body, $template_id, $order, $max_results);
        return $response;
    }

    /**
     * Operation findByParametersWithHttpInfo
     *
     * Retrieve all documents that match the list of criteria
     *
     * @param  \Swagger\Client\Model\WSCriterion[] $body an array of search criteria that must be met (optional)
     * @param  int $template_id the type of documents to be retrieved (optional)
     * @param  string $order optional order expression (eg. creation desc) (optional)
     * @param  int $max_results maximum number of results (optional)
     *
     * @throws \Swagger\Client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \Swagger\Client\Model\WSDocument[], HTTP status code, HTTP response headers (array of strings)
     */
    public function findByParametersWithHttpInfo($body = null, $template_id = null, $order = null, $max_results = null)
    {
        $returnType = '\Swagger\Client\Model\WSDocument[]';
        $request = $this->findByParametersRequest($body, $template_id, $order, $max_results);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? $e->getResponse()->getBody()->getContents() : null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }

            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = $responseBody->getContents();
                if (!in_array($returnType, ['string','integer','bool'])) {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 0:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Swagger\Client\Model\WSDocument[]',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation findByParametersAsync
     *
     * Retrieve all documents that match the list of criteria
     *
     * @param  \Swagger\Client\Model\WSCriterion[] $body an array of search criteria that must be met (optional)
     * @param  int $template_id the type of documents to be retrieved (optional)
     * @param  string $order optional order expression (eg. creation desc) (optional)
     * @param  int $max_results maximum number of results (optional)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function findByParametersAsync($body = null, $template_id = null, $order = null, $max_results = null)
    {
        return $this->findByParametersAsyncWithHttpInfo($body, $template_id, $order, $max_results)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation findByParametersAsyncWithHttpInfo
     *
     * Retrieve all documents that match the list of criteria
     *
     * @param  \Swagger\Client\Model\WSCriterion[] $body an array of search criteria that must be met (optional)
     * @param  int $template_id the type of documents to be retrieved (optional)
     * @param  string $order optional order expression (eg. creation desc) (optional)
     * @param  int $max_results maximum number of results (optional)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function findByParametersAsyncWithHttpInfo($body = null, $template_id = null, $order = null, $max_results = null)
    {
        $returnType = '\Swagger\Client\Model\WSDocument[]';
        $request = $this->findByParametersRequest($body, $template_id, $order, $max_results);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'findByParameters'
     *
     * @param  \Swagger\Client\Model\WSCriterion[] $body an array of search criteria that must be met (optional)
     * @param  int $template_id the type of documents to be retrieved (optional)
     * @param  string $order optional order expression (eg. creation desc) (optional)
     * @param  int $max_results maximum number of results (optional)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    protected function findByParametersRequest($body = null, $template_id = null, $order = null, $max_results = null)
    {

        $resourcePath = '/enterpriseSearch/findByParameters';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        if ($template_id !== null) {
            $queryParams['templateId'] = ObjectSerializer::toQueryValue($template_id, 'int64');
        }
        // query params
        if ($order !== null) {
            $queryParams['order'] = ObjectSerializer::toQueryValue($order, null);
        }
        // query params
        if ($max_results !== null) {
            $queryParams['maxResults'] = ObjectSerializer::toQueryValue($max_results, 'int32');
        }


        // body params
        $_tempBody = null;
        if (isset($body)) {
            $_tempBody = $body;
        }

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['application/json']
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            $httpBody = $_tempBody;
            // \stdClass has no __toString(), so we should encode it manually
            if ($httpBody instanceof \stdClass && $headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($httpBody);
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $multipartContents[] = [
                        'name' => $formParamName,
                        'contents' => $formParamValue
                    ];
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\build_query($formParams);
            }
        }

        // this endpoint requires HTTP basic authentication
        if ($this->config->getUsername() !== null || $this->config->getPassword() !== null) {
            $headers['Authorization'] = 'Basic ' . base64_encode($this->config->getUsername() . ":" . $this->config->getPassword());
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = \GuzzleHttp\Psr7\build_query($queryParams);
        return new Request(
            'POST',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation findDocumentsByParameters
     *
     * Retrieve all documents that match the list of criteria
     *
     * @param  \Swagger\Client\Model\WSCriterion[] $body an array of search criteria that must be met (optional)
     * @param  int $template_id the type of documents to be retrieved (optional)
     * @param  string $order optional order expression (eg. creation desc) (optional)
     * @param  int $max_results maximum number of results (optional)
     *
     * @throws \Swagger\Client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \Swagger\Client\Model\WSDocument[]
     */
    public function findDocumentsByParameters($body = null, $template_id = null, $order = null, $max_results = null)
    {
        list($response) = $this->findDocumentsByParametersWithHttpInfo($body, $template_id, $order, $max_results);
        return $response;
    }

    /**
     * Operation findDocumentsByParametersWithHttpInfo
     *
     * Retrieve all documents that match the list of criteria
     *
     * @param  \Swagger\Client\Model\WSCriterion[] $body an array of search criteria that must be met (optional)
     * @param  int $template_id the type of documents to be retrieved (optional)
     * @param  string $order optional order expression (eg. creation desc) (optional)
     * @param  int $max_results maximum number of results (optional)
     *
     * @throws \Swagger\Client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \Swagger\Client\Model\WSDocument[], HTTP status code, HTTP response headers (array of strings)
     */
    public function findDocumentsByParametersWithHttpInfo($body = null, $template_id = null, $order = null, $max_results = null)
    {
        $returnType = '\Swagger\Client\Model\WSDocument[]';
        $request = $this->findDocumentsByParametersRequest($body, $template_id, $order, $max_results);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? $e->getResponse()->getBody()->getContents() : null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }

            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = $responseBody->getContents();
                if (!in_array($returnType, ['string','integer','bool'])) {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 0:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Swagger\Client\Model\WSDocument[]',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation findDocumentsByParametersAsync
     *
     * Retrieve all documents that match the list of criteria
     *
     * @param  \Swagger\Client\Model\WSCriterion[] $body an array of search criteria that must be met (optional)
     * @param  int $template_id the type of documents to be retrieved (optional)
     * @param  string $order optional order expression (eg. creation desc) (optional)
     * @param  int $max_results maximum number of results (optional)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function findDocumentsByParametersAsync($body = null, $template_id = null, $order = null, $max_results = null)
    {
        return $this->findDocumentsByParametersAsyncWithHttpInfo($body, $template_id, $order, $max_results)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation findDocumentsByParametersAsyncWithHttpInfo
     *
     * Retrieve all documents that match the list of criteria
     *
     * @param  \Swagger\Client\Model\WSCriterion[] $body an array of search criteria that must be met (optional)
     * @param  int $template_id the type of documents to be retrieved (optional)
     * @param  string $order optional order expression (eg. creation desc) (optional)
     * @param  int $max_results maximum number of results (optional)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function findDocumentsByParametersAsyncWithHttpInfo($body = null, $template_id = null, $order = null, $max_results = null)
    {
        $returnType = '\Swagger\Client\Model\WSDocument[]';
        $request = $this->findDocumentsByParametersRequest($body, $template_id, $order, $max_results);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'findDocumentsByParameters'
     *
     * @param  \Swagger\Client\Model\WSCriterion[] $body an array of search criteria that must be met (optional)
     * @param  int $template_id the type of documents to be retrieved (optional)
     * @param  string $order optional order expression (eg. creation desc) (optional)
     * @param  int $max_results maximum number of results (optional)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    protected function findDocumentsByParametersRequest($body = null, $template_id = null, $order = null, $max_results = null)
    {

        $resourcePath = '/enterpriseSearch/findDocumentsByParameters';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        if ($template_id !== null) {
            $queryParams['templateId'] = ObjectSerializer::toQueryValue($template_id, 'int64');
        }
        // query params
        if ($order !== null) {
            $queryParams['order'] = ObjectSerializer::toQueryValue($order, null);
        }
        // query params
        if ($max_results !== null) {
            $queryParams['maxResults'] = ObjectSerializer::toQueryValue($max_results, 'int32');
        }


        // body params
        $_tempBody = null;
        if (isset($body)) {
            $_tempBody = $body;
        }

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['application/json']
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            $httpBody = $_tempBody;
            // \stdClass has no __toString(), so we should encode it manually
            if ($httpBody instanceof \stdClass && $headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($httpBody);
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $multipartContents[] = [
                        'name' => $formParamName,
                        'contents' => $formParamValue
                    ];
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\build_query($formParams);
            }
        }

        // this endpoint requires HTTP basic authentication
        if ($this->config->getUsername() !== null || $this->config->getPassword() !== null) {
            $headers['Authorization'] = 'Basic ' . base64_encode($this->config->getUsername() . ":" . $this->config->getPassword());
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = \GuzzleHttp\Psr7\build_query($queryParams);
        return new Request(
            'POST',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation queryDocuments
     *
     * Queries the database to search for documents
     *
     * @param  string $select select (optional)
     * @param  string $tables tables (optional)
     * @param  string $where where (optional)
     * @param  string $order order (optional)
     * @param  int $max_results max_results (optional)
     *
     * @throws \Swagger\Client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return string[][]
     */
    public function queryDocuments($select = null, $tables = null, $where = null, $order = null, $max_results = null)
    {
        list($response) = $this->queryDocumentsWithHttpInfo($select, $tables, $where, $order, $max_results);
        return $response;
    }

    /**
     * Operation queryDocumentsWithHttpInfo
     *
     * Queries the database to search for documents
     *
     * @param  string $select (optional)
     * @param  string $tables (optional)
     * @param  string $where (optional)
     * @param  string $order (optional)
     * @param  int $max_results (optional)
     *
     * @throws \Swagger\Client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of string[][], HTTP status code, HTTP response headers (array of strings)
     */
    public function queryDocumentsWithHttpInfo($select = null, $tables = null, $where = null, $order = null, $max_results = null)
    {
        $returnType = 'string[][]';
        $request = $this->queryDocumentsRequest($select, $tables, $where, $order, $max_results);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? $e->getResponse()->getBody()->getContents() : null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }

            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = $responseBody->getContents();
                if (!in_array($returnType, ['string','integer','bool'])) {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 0:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        'string[][]',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation queryDocumentsAsync
     *
     * Queries the database to search for documents
     *
     * @param  string $select (optional)
     * @param  string $tables (optional)
     * @param  string $where (optional)
     * @param  string $order (optional)
     * @param  int $max_results (optional)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function queryDocumentsAsync($select = null, $tables = null, $where = null, $order = null, $max_results = null)
    {
        return $this->queryDocumentsAsyncWithHttpInfo($select, $tables, $where, $order, $max_results)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation queryDocumentsAsyncWithHttpInfo
     *
     * Queries the database to search for documents
     *
     * @param  string $select (optional)
     * @param  string $tables (optional)
     * @param  string $where (optional)
     * @param  string $order (optional)
     * @param  int $max_results (optional)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function queryDocumentsAsyncWithHttpInfo($select = null, $tables = null, $where = null, $order = null, $max_results = null)
    {
        $returnType = 'string[][]';
        $request = $this->queryDocumentsRequest($select, $tables, $where, $order, $max_results);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'queryDocuments'
     *
     * @param  string $select (optional)
     * @param  string $tables (optional)
     * @param  string $where (optional)
     * @param  string $order (optional)
     * @param  int $max_results (optional)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    protected function queryDocumentsRequest($select = null, $tables = null, $where = null, $order = null, $max_results = null)
    {

        $resourcePath = '/enterpriseSearch/queryDocuments';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // form params
        if ($select !== null) {
            $formParams['select'] = ObjectSerializer::toFormValue($select);
        }
        // form params
        if ($tables !== null) {
            $formParams['tables'] = ObjectSerializer::toFormValue($tables);
        }
        // form params
        if ($where !== null) {
            $formParams['where'] = ObjectSerializer::toFormValue($where);
        }
        // form params
        if ($order !== null) {
            $formParams['order'] = ObjectSerializer::toFormValue($order);
        }
        // form params
        if ($max_results !== null) {
            $formParams['maxResults'] = ObjectSerializer::toFormValue($max_results);
        }
        // body params
        $_tempBody = null;

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['application/x-www-form-urlencoded']
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            $httpBody = $_tempBody;
            // \stdClass has no __toString(), so we should encode it manually
            if ($httpBody instanceof \stdClass && $headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($httpBody);
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $multipartContents[] = [
                        'name' => $formParamName,
                        'contents' => $formParamValue
                    ];
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\build_query($formParams);
            }
        }

        // this endpoint requires HTTP basic authentication
        if ($this->config->getUsername() !== null || $this->config->getPassword() !== null) {
            $headers['Authorization'] = 'Basic ' . base64_encode($this->config->getUsername() . ":" . $this->config->getPassword());
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = \GuzzleHttp\Psr7\build_query($queryParams);
        return new Request(
            'POST',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Create http client option
     *
     * @throws \RuntimeException on file opening failure
     * @return array of http client options
     */
    protected function createHttpClientOption()
    {
        $options = [];
        if ($this->config->getDebug()) {
            $options[RequestOptions::DEBUG] = fopen($this->config->getDebugFile(), 'a');
            if (!$options[RequestOptions::DEBUG]) {
                throw new \RuntimeException('Failed to open the debug file: ' . $this->config->getDebugFile());
            }
        }

        return $options;
    }
}
