<?php
/**
 * @license    License compatible with GNU General Public License (GNU GPL); see file LICENSE
 */

/**
 * ApiException
 * PHP version 5
 *
 * @category Class
 * @package  Swagger\Client
 * @author   Swagger Codegen team
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * LogicalDOC REST API
 *
 * This is the interactive documentation of the REST APIs exposed by LogicalDOC. You can find more information about LogicalDOC at <a href=\"https://www.logicaldoc.com\">https://www.logicaldoc.com</a> or on Twitter @logicaldoc.<br/>                Note: The access path to the API is protected with basic authentication, to be able to run the samples you must log in using the credentials of a Logicaldoc user, or passing to the request the session ID (SID) as a cookie (cookie name: `ldoc-sid`).<br/><br/>             Here is an example to list the children folders: <br/> <pre>curl -u admin:admin -H 'Accept: application/json' http://localhost:8080/services/rest/folder/listChildren?folderId=4</pre><br/><br/>RESTful Guide with curl:  <a href='https://wiki.logicaldoc.com/wiki/RESTful_Guide_with_curl'>https://wiki.logicaldoc.com/wiki/RESTful_Guide_with_curl</a> <br/><br/>Practical examples of use are available for various programming languages at: <a href='http://wiki.logicaldoc.com/wiki/Bindings_And_Samples'>http://wiki.logicaldoc.com/wiki/Bindings_And_Samples</a>
 *
 * OpenAPI spec version: 8.6.0-oas3
 * Contact: devel@logicaldoc.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 * Swagger Codegen version: 3.0.33
 */
/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace Swagger\Client;

defined('_JEXEC') or die('Restricted access');


use \Exception;

/**
 * ApiException Class Doc Comment
 *
 * @category Class
 * @package  Swagger\Client
 * @author   Swagger Codegen team
 * @link     https://github.com/swagger-api/swagger-codegen
 */
class HeaderSelector
{

    /**
     * @param string[] $accept
     * @param string[] $contentTypes
     * @return array
     */
    public function selectHeaders($accept, $contentTypes)
    {
        $headers = [];

        $accept = $this->selectAcceptHeader($accept);
        if ($accept !== null) {
            $headers['Accept'] = $accept;
        }

        $headers['Content-Type'] = $this->selectContentTypeHeader($contentTypes);
        return $headers;
    }

    /**
     * @param string[] $accept
     * @return array
     */
    public function selectHeadersForMultipart($accept)
    {
        $headers = $this->selectHeaders($accept, []);

        unset($headers['Content-Type']);
        return $headers;
    }

    /**
     * Return the header 'Accept' based on an array of Accept provided
     *
     * @param string[] $accept Array of header
     *
     * @return string Accept (e.g. application/json)
     */
    private function selectAcceptHeader($accept)
    {
        if (count($accept) === 0 || (count($accept) === 1 && $accept[0] === '')) {
            return null;
        } elseif (preg_grep("/application\/json/i", $accept)) {
            return 'application/json';
        } else {
            return implode(',', $accept);
        }
    }

    /**
     * Return the content type based on an array of content-type provided
     *
     * @param string[] $contentType Array fo content-type
     *
     * @return string Content-Type (e.g. application/json)
     */
    private function selectContentTypeHeader($contentType)
    {
        if (count($contentType) === 0 || (count($contentType) === 1 && $contentType[0] === '')) {
            return 'application/json';
        } elseif (preg_grep("/application\/json/i", $contentType)) {
            return 'application/json';
        } else {
            return implode(',', $contentType);
        }
    }
}

