<?php
/**
 * @package    FILEman
 * @copyright   Copyright (C) 2011 Timble CVBA (http://www.timble.net)
 * @license     GNU GPLv3 <http://www.gnu.org/licenses/gpl.html>
 * @link        http://www.joomlatools.com
 */

class ComFilemanTemplateHelperBehavior extends ComKoowaTemplateHelperBehavior
{
    public function multidownload($config = [])
    {
        $config = new KObjectConfigJson($config);
        $config->append([]);

        $html = '';

        if (!static::isLoaded('fileman-multidownload'))
        {
            $html = $this->jquery($config);
            $html .= $this->tooltip($config);
            $html .= $this->getTemplate()->helper('translator.script', ['strings' => [
                'Preparing download'
            ]]);
            $html .= '<ktml:script src="media://com_fileman/js/multidownload.js" />';
            $html .= '
            <style>
                /* get rid of the red-on-white button on hover */
                .k-js-multi-download.disabled:hover {
                    background-color: inherit !important;
                    color: inherit !important;
                }
            </style>
            <script>
            
                if (typeof Fileman === "undefined") {
                    Fileman = {};
                }
            
                Fileman.token = '.json_encode($this->getObject('user')->getSession()->getToken()).';
            </script>
            ';

            static::setLoaded('fileman-multidownload');
        }

        return $html;
    }

    public function image_editor($config = array())
    {
        $identifier = $this->getTemplate()->getIdentifier();

        $config = new KObjectConfigJson($config);
        $config->append([
            'debug'   => JFactory::getApplication()->getCfg('debug'),
            'type'    => $identifier->domain,
            'options' => [
                'site'              => (string) $this->getObject('request')->getSiteUrl(),
                'hasConnectSupport' => class_exists('PlgKoowaConnect') && PlgKoowaConnect::isSupported(),
            ],
        ])->append([
            'options' => [
                'connectToken' => $config->options->hasConnectSupport ? PlgKoowaConnect::generateToken() : false,
            ]
        ]);

        $html = $this->getTemplate()->helper('translator.script', [
            'strings' => [
                'Image editor is available with Joomlatools Connect'
            ]
        ]);

        $type = json_encode($config->type);

        $html .= $this->jquery($config);
        $html .= $this->tooltip($config);
        $html .= '<ktml:script src="media://com_fileman/js/image.editor.js" />';
        $html .= "<script>
            kQuery(function(){
                Fileman.ImageEditorFactory.getEditor({$type}, ".$config->options.");
            });
            </script>";

        return $html;
    }

    /**
     * Uses Google Analytics to track download events in the frontend
     * 
     * @param array $config
     * @return string
     */
    public function download_tracker($config = array())
    {
        $config = new KObjectConfigJson($config);
        $config->append(array(
            'selector' => 'fileman_track_download',
            'category' => 'FILEman',
            'action'   => 'Download'
        ));

        $html = $this->jquery();

        $signature = md5(serialize(array($config->selector, $config->category, $config->action)));
        if (!static::isLoaded($signature)) {
            $html .= "
            <script>
            kQuery(function($) {
                $('.{$config->selector}').on('click', function() {
                    var el = $(this);

                    if (typeof gtag !== 'undefined') {
                        gtag('event', '{$config->action}', {
                            'event_category': '{$config->category}',
                            'event_label': el.data('title'),
                            'name': el.data('title'),
                            'value': parseInt(el.data('id'), 10)
                        });
                    }
                    else if (typeof window.GoogleAnalyticsObject !== 'undefined' && typeof window[window.GoogleAnalyticsObject] !== 'undefined') {
                        window[window.GoogleAnalyticsObject]('send', 'event', '{$config->category}', '{$config->action}', el.data('title'), parseInt(el.data('id'), 10));
                    } 
                    else if (typeof _gaq !== 'undefined' && typeof _gat !== 'undefined') {
                        if (_gat._getTrackers().length) {
                            _gaq.push(function() {
                                var tracker = _gat._getTrackers()[0];
                                tracker._trackEvent('{$config->category}', '{$config->action}', el.data('title'), parseInt(el.data('id'), 10));
                            });
                        }
                    }
                });

                if (typeof _paq !== 'undefined') {
                    _paq.push(['setDownloadClasses', '{$config->selector}']);
                    _paq.push(['trackPageView']);
                }
            });
            </script>
            ";
            static::setLoaded($signature);
        }
      
        return $html;
    }

    /**
     * A feature to tick multiple checkboxes at the same time
     * Tick a range of checkboxes by holding the 'shift' key
     * 
     * @param mixed $config
     * @return string
     */
    public function multiselect($config = [])
    {
        $config = new KObjectConfigJson();
        $config->append([
            'selector' => '.k-js-item-select'
        ]);

        $html = '';

        if (!static::isLoaded('fileman-multiselect'))
        {
            $html = "<script>
                kQuery(function(){
                    var checkboxes = kQuery('{$config->selector}');
                    var lastChecked = null;
                
                    checkboxes.click(function(e) {
                        if (!lastChecked) {
                            lastChecked = this;
                            return;
                        }
                
                        if (e.shiftKey) {
                            var start = checkboxes.index(this);
                            var end = checkboxes.index(lastChecked);
                
                            checkboxes.slice(Math.min(start,end), Math.max(start,end)+ 1).prop('checked', lastChecked.checked);
                        }
                
                        lastChecked = this;
                    })
                });
                </script>";
            
            static::setLoaded('fileman-multiselect');
        }

        return $html;
    }
}