<?php
/**
 * @package     FILEman
 * @copyright   Copyright (C) 2011 Timble CVBA. (http://www.timble.net)
 * @license     GNU GPLv3 <http://www.gnu.org/licenses/gpl.html>
 * @link        http://www.joomlatools.com
 */

class ComFilemanTemplateHelperModal extends ComFilesTemplateHelperModal
{
	public function select($config = array())
	{
		$config = new KObjectConfigJson($config);
		$config->append(array(
				'name'      => '',
				'id'        => '',
				'visible'   => true,
				'link'      => '',
                'link_text' => $this->getObject('translator')->translate('Select'),
				'link_selector' => version_compare(JVERSION, '4.0', '<') ? 'modal' : ''
		))->append(array(
				'value' => $config->name,
				'id' => $config->name
		));

		$input = '<input class="form-control" name="%1$s" id="%4$s" value="%2$s" %3$s size="40" />';

		$link = '<a class="btn btn-primary %s" 

data-bs-target="#filemanFileModal" class="btn btn-primary" data-bs-toggle="modal"
                rel="{\'ajaxOptions\': {\'method\': \'get\'}, \'handler\': \'iframe\', \'size\': {\'x\': 900}}"
                href="%s"><i class="icon-list icon-white"></i> %s</a>';

		$html  = sprintf($input, $config->name, $this->getTemplate()->escape($config->value), $config->visible ? 'type="text" readonly' : 'type="hidden"', $config->id);
		$html .= sprintf($link, $config->link_selector, $config->link, $config->link_text);

		$html = '<span class="input-append input-group">'.$html.'</span>';

        $html .= Joomla\CMS\HTML\HTMLHelper::_(
            'bootstrap.renderModal',
            'filemanFileModal',
            array(
                'url'        => $config->link,
                'closeButton' => false,
                'title'      => '',
                'width'      => '800px',
                'height'     => '300px',
                'modalWidth' => 80,
                'bodyHeight' => 70,
                'footer'     => false
            )
        );

		return $html;
	}
}